//FIR BAND PASS FILTER - REMEZ ALGORITHM -FOR LPF
//OS:Windows 10
//Scilab 5.5.2

//Band Pass Filter of length M = 16
//Lower Cutoff frequency fp = 0.2 and Upper Cutoff frequency fs = 0.3

clear all;
clc;
close;
hn = 0;
hm = 0;
hn=eqfir(16,[0 .1;.2 .35;.425 .5],[0 1 0],[10 1 10]);//number of cosine functions,pass band magnitude&stop band,weighting function
[hm,fr]=frmag(hn,256);
disp(hn,'The Filter Coefficients are:')
figure
plot(.5*(0:255)/256,20*log10(frmag(hn,256)));
a = gca();
xlabel('Normalized Digital Frequency fr');
ylabel('Magnitude in dB');
title('Frequency Response of FIR BPF using REMEZ algorithm M=16')
xgrid(2)

//Output
// 
// The Filter Coefficients are:
//
//  -0.0395487
//   0.0232284
//   0.0480681
//  -0.0218794
//   0.0975735
//  -0.1012773
//  -0.2880134
//   0.2847346
//   0.2847346
//  -0.2880134
//  -0.1012773
//   0.0975735
//  -0.0218794
//   0.0480681
//   0.0232284
//  -0.0395487
//
